/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/  

/**
 * \file    eeprom.h
 *
 * \brief   Defines the module register defines for I2C serial EEPROM
 *
 * This header file contains the Macros definitions corresponding to
 * I2C based Serial EEPROM used in the DM814X EVM.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created.
 */
#ifndef _eeprom_H_
#define _eeprom_H_


#include "DM814x_i2c.h"

/* ------------------------------------------------------------------------ *
 *  I2C Address                                                             *
 * ------------------------------------------------------------------------ */
#define EEPROM_I2C_ADDR             0x50
#define EEPROM_I2C_BUS_NUM			0

/* ------------------------------------------------------------------------ *
 *  EEPROM Memory Settings                                                  *
 * ------------------------------------------------------------------------ */
#define EEPROM_PAGE_SIZE            64
#define EEPROM_PAGE_SIZE_POW2       6
#define EEPROM_MAX_BURST_LEN        EEPROM_PAGE_SIZE

/* ------------------------------------------------------------------------ *
 *  Prototypes                                                              *
 * ------------------------------------------------------------------------ */
STATUS EEPROM_init ( );
STATUS EEPROM_read ( UINT32 src, UINT32 dst, UINT32 length );
STATUS EEPROM_write( UINT32 src, UINT32 dst, UINT32 length );

#endif /* _eeprom_H_ */
